
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              November 2018                        *
*****************************************************

*****************************************************
* Das multiple Regressionsmodell
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd   "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files"        //Arbeitsverzeichnis
use  AllbReg, clear


* ---------------------------------------
* Datenaufbereitung
* ---------------------------------------
* Nur hauptberuflich ganztags, bis Alter 65
keep if  hauptber == 1
keep if  alter <  66

tabulate beruf, gen(d)       // Generierung der Berufs-Dummies


* ----------------------------------
* Regression mit Geschlechts-Dummy
* ----------------------------------
regress eink bild frau

   
* ----------------------------------
* Regression mit Berufs-Dummies
* ----------------------------------

* Checks der Dummies
tabulate beruf d1
table beruf, contents(sum d1 sum d2 sum d3 sum d4)

* Bivariate Regression
table beruf, contents(mean eink)
regr eink d2 d3 d4

* Multiple Regression (mit Faktor-Variablen Syntax)
regress eink bild i.beruf

* Signifikanz des Berufs
testparm i.beruf    // oder "contrast beruf"

* Multiple Regression (Beamte als Referenz)
regress eink bild ib3.beruf
contrast rb3.beruf, asobserved


